;------------------------------------
; RobotBob's (Eric Asbell) 
; Accesing COM from RosAsm example #3
; For ITaskBarList
;------------------------------------

; Handy Macros
[push | push #1 | #+1]  
[pop | pop #1 | #+1]     
[call | push #L>2 | call #1]

; Dialog Information - Not important in our example
[DialogHandle: D$ 0]
[BoxTitle: B$ 'Yeah!' 0]
[NowDelete: B$ 'We left the Taskbar!' 0 ]
[NowAdd: B$ 'We are back!' 0]

; Our macro to call com functions!
; Example :  iCall Lock D$BackSurfacePtr &NULL DDSURFACEDESC DDLOCK_WAIT &NULL
[iCall | mov edx #2 | mov edx D$edx | push #L>3 | push #2 | call D$edx+#1 ]

; ITaskbarList Interface  
[ITaskbarList_QueryInterface         0
ITaskbarList_AddRef                  4
ITaskbarList_Release                 8  
ITaskbarList_HrInit                 12
ITaskbarList_AddTab                 16
ITaskbarList_DeleteTab              20
ITaskbarList_ActivateTab            24
ITaskbarList_SetActiveAlt           28]

; CLSID_ITaskbarList {56FDF344-FD6D-11D0-958A-006097C9A090}   
[ CLSID_ITaskbarList:
cData1: D$ 056FDF344H
cData2: W$ 0FD6DH
cData3: W$ 011D0H]
[cData4: B$ 095 08A 000 060 097 0C9 0A0 090]

; IID_ITaskbarList  {56FDF342-FD6D-11D0-958A-006097C9A090}  
[IID_ITaskbarList:
iData1: D$ 056FDF342H
iData2: W$ 0FD6DH
iData3: W$ 011D0H]
[iData4: B$ 095 08A 000 060 097 0C9 0A0 090]

[ObjectPointer: D$ 0]


Main:        
        call 'USER32.DialogBoxParamA'  0 1000 0 DialogProc 0
        mov D$DialogHandle eax        
        call 'KERNEL32.ExitProcess' 0
ret


DialogProc:
     
    push ebp | mov ebp esp

    pushad
           
    cmp D$ebp+12 &WM_COMMAND | jne L1>>
        cmp D$ebp+16 100 | jne L2>>
        
                call 'OLE32.CoInitializeEx' &NULL &COINIT_APARTMENTTHREADED
        
                call 'OLE32.CoCreateInstance' CLSID_ITaskbarList &NULL, 
                                    &CLSCTX_INPROC_SERVER, 
                                    IID_ITaskbarList ObjectPointer
                                    
                ; Initializes the taskbar list object. This method must be 
                ; called before any other ITaskbarList methods can be called.                     
                iCall ITaskbarList_HrInit D$ObjectPointer
                              
                ; Deletes an item from the taskbar.                                
                iCall ITaskbarList_DeleteTab D$ObjectPointer D$ebp+8
                
                ; Just here to point out the taskbar change
                call 'KERNEL32.Sleep' 3000                
                call 'USER32.MessageBoxA' 0 NowDelete BoxTitle 0
                
                ; Adds an item to the taskbar
                ; Any type of window can be added to the taskbar, but it is 
                ; recommended that the window at least have the WS_CAPTION style.
                iCall ITaskbarList_AddTab D$ObjectPointer D$ebp+8
                
                ; Activates an item on the taskbar. The window is not actually 
                ; activated; the window's item on the taskbar is merely displayed as active. 
                iCall ITaskbarList_ActivateTab D$ObjectPointer D$ebp+8  
                
                ; Just here to point out the taskbar change
                call 'KERNEL32.Sleep' 1000
                call 'USER32.MessageBoxA' 0 NowAdd BoxTitle 0
                
                ; Decrements the reference count for the calling interface on a 
                ; object. If the reference count on the object falls to 0, the 
                ; object is freed from memory.
                iCall ITaskbarList_Release D$ObjectPointer
                
                call 'OLE32.CoUninitialize'
          
        jmp L9>>
L2:        
    jmp L9>
    
L1: cmp D$ebp+12 &WM_CLOSE
    jne L1>   
        call 'User32.EndDialog' D$ebp+8 &TRUE   
    jmp L9>
L1:
         
L9: 
    popad    
    mov eax &FALSE
    mov esp ebp | pop ebp | ret 16



